/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.commands;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.utils.PasswordProtectUtilities;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectSetPasswordCommand
implements CommandExecutor {
    private final PasswordProtect plugin;
    private final PasswordProtectUtilities utils;

    public PasswordProtectSetPasswordCommand(PasswordProtect instance) {
        this.plugin = instance;
        this.utils = instance.getUtils();
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        if (args.length != 1) {
            return false;
        }
        if (!sender.hasPermission("passwordprotect.setpassword")) {
            String messageLocalization = this.plugin.getLocalization().getString("permission_denied");
            this.utils.message(sender, messageLocalization, null);
            return true;
        }
        String password = args[0];
        this.utils.setPassword(password);
        String messageLocalization = this.plugin.getLocalization().getString("password_set");
        this.utils.message(sender, messageLocalization, null);
        if (sender instanceof Player) {
            messageLocalization = this.plugin.getLocalization().getString("set_jail_area");
            this.utils.message(sender, messageLocalization, null);
        }
        return true;
    }
}

